/*
 * serial_communication.h
 *
 *  Created on: May 29, 2019
 *      Author: zbjg7b
 */


#include "..\my_uart\my_uart_prm.h"

#ifndef SRC_MY_SETUP_SERIAL_COMMUNICATION_SERIAL_COMMUNICATION_H_
#define SRC_MY_SETUP_SERIAL_COMMUNICATION_SERIAL_COMMUNICATION_H_

// --- Definition
	/* --- Protocol Definition  --- */
	#define ID_LEN			0	// first received char is the number of bytes associated with this message
	#define ID_CMD			1	// type of command
	#define ID_DATA			2	// start of the data field
	#define NUM_CHANNELS	8

typedef enum
{
/*0*/	SERIAL_CMD_NO_ID,
/*1*/	SERIAL_CMD_ID_CONNECT,
/*2*/	SERIAL_CMD_ID_SW_VERSION,
/*3*/	SERIAL_CMD_ID_SET_CHANNEL,
/*4*/	SERIAL_CMD_ID_SET_SPD_PRM,
/*5*/	SERIAL_CMD_ID_START_HIGH_FREQ_COM,
/*6*/	SERIAL_CMD_ID_STOP_HIGH_FREQ_COM,
/*7*/	SERIAL_CMD_ID_SET_FREQ_RATE,
/*8*/	SERIAL_CMD_ID_READ_MOT_PRM,
/*9*/	SERIAL_CMD_ID_READ_CH_SELECTION,
/*A*/	SERIAL_CMD_ID_STOP_THE_MOTOR,
/*B*/	SERIAL_CMD_ID_READ_CNTRL_PRM,
/*C*/	SERIAL_CMD_ID_SET_CNTRL_PRM,
/*D*/	SERIAL_CMD_ERROR_CRC,
/*E*/	SERIAL_CMD_ERROR_UNKNOWN,
/*F*/	SERIAL_CMD_ID_DISCONNECT,
/*10*/  SERIAL_CMD_ID_READ_MOTOR_VALUES,
/*11*/  SERIAL_CMD_ID_RESET_ERROR
	} ENUM_SERIAL_CMD_ID;

	typedef enum {
		ERROR_NOpERROR,
		ERROR_ADCpTHRESHOLDpOUTSIDEpRANGE,
		ERROR_STARTUPpCURRENTpINJECTIONpERROR,
		ERROR_STARTUPpCURRENTpINJECTION2pERROR
	} MOTOR_ERRORS;

	// The naming modification has been changed to simplify the GUI
	// generation in python. It is still not back-compatible with the MotorSW
	typedef enum
	{
			// Speed Ramp Variable
	/*0*/	SER_RAMP_B1_F1_TRG_SPEED,
	/*1*/	SER_RAMP_BS_FS_TRG_SPEED,
	/*2*/	SER_RAMP_B1_F1_TRG_ACC,
	/*3*/	SER_RAMP_BS_FS_REF_SPEED,
	/*4*/	SER_RAMP_BS_FS_TRG_ACC,
	/*5*/	SER_RAMP_BR_FR_ANG_RAD,

			// Analog Measure
	/*6*/	SER_MEAS_BV_FV_ADC_VBUSpCOARSE,
	/*7*/	SER_MEAS_BI_FI_ADC_IU,
	/*8*/	SER_MEAS_BI_FI_ADC_IV,
	/*9*/	SER_MEAS_BI_FI_ADC_IW,
	/*10*/  SER_MEAS_BV_FV_ADC_VU,
	/*11*/	SER_MEAS_BV_FV_ADC_VV,
	/*12*/  SER_MEAS_BV_FV_ADC_VW,
	/*13*/	SER_MEAS_BV_FV_ADC_VBUSpFINE,
	/*14*/	SER_MEAS_B1_F1_ADC_VBUSpCOARSEpRAW,
	/*15*/	SER_MEAS_B1_F1_ADC_IUpRAW,
	/*16*/	SER_MEAS_B1_F1_ADC_IVpRAW,
	/*17*/	SER_MEAS_B1_F1_ADC_IWpRAW,
	/*18*/	SER_MEAS_B1_F1_ADC_VUpRAW,
	/*19*/	SER_MEAS_B1_F1_ADC_VVpRAW,
	/*20*/	SER_MEAS_B1_F1_ADC_VWpRAW,
	/*21*/	SER_MEAS_B1_F1_ADC_VBUSpFINEpRAW,
	/*22*/	SER_MEAS_B1_F1_ADC_VBUSpCOARSEpOFF,
	/*23*/	SER_MEAS_B1_F1_ADC_IUpOFF,
	/*24*/	SER_MEAS_B1_F1_ADC_IVpOFF,
	/*25*/	SER_MEAS_B1_F1_ADC_IWpOFF,
	/*26*/	SER_MEAS_B1_F1_ADC_VUpOFF,
	/*27*/	SER_MEAS_B1_F1_ADC_VVpOFF,
	/*28*/	SER_MEAS_B1_F1_ADC_VWpOFF,
	/*29*/	SER_MEAS_B1_F1_ADC_VBUSpFINEpOFF,

			// Trigonometric Function
	/*30*/	SER_TRIG_BR_FR_EST_SIN,
	/*31*/	SER_TRIG_BR_FR_EST_COS,
	/*32*/	SER_TRIG_BR_FR_EST_SINpDEADTIME,
	/*33*/	SER_TRIG_BR_FR_EST_COSpDEADTIME,

			// ID Regulator Function
	/*34*/	SER_PIREG_BI_FI_ID_REF,
	/*35*/	SER_PIREG_BI_FI_ID_MEAS,
	/*36*/	SER_PIREG_BI_FI_ID_ERR,
	/*37*/	SER_PIREG_BV_FV_ID_LIMpUP,
	/*38*/	SER_PIREG_BV_FV_ID_LIMpDW,
	/*39*/	SER_PIREG_BV_FV_ID_INTEGpLIMpUP,
	/*40*/	SER_PIREG_BV_FV_ID_INTEGpLIMpDW,
	/*41*/	SER_PIREG_BV_FV_ID_PROP,
	/*42*/	SER_PIREG_BV_FV_ID_INTEG,

			// IQ Regulator Function
	/*43*/	SER_PIREG_BI_FI_IQ_REF,
	/*44*/	SER_PIREG_BI_FI_IQ_MEAS,
	/*45*/	SER_PIREG_BI_FI_IQ_ERR,
	/*46*/	SER_PIREG_BV_FV_IQ_LIMpUP,
	/*47*/	SER_PIREG_BV_FV_IQ_LIMpDW,
	/*48*/	SER_PIREG_BV_FV_IQ_INTEGpLIMpUP,
	/*49*/	SER_PIREG_BV_FV_IQ_INTEGpLIMpDW,
	/*50*/	SER_PIREG_BV_FV_IQ_PROP,
	/*51*/	SER_PIREG_BV_FV_IQ_INTEG,

	 		// ED Regulator Function
	/*52*/	SER_PIREG_BV_FV_ED_REF,
	/*53*/	SER_PIREG_BV_FV_ED_MEAS,
	/*54*/	SER_PIREG_BV_FV_ED_ERR,
	/*55*/	SER_PIREG_BW_FW_ED_LIMpUP,
	/*56*/	SER_PIREG_BW_FW_ED_LIMpDW,
	/*57*/	SER_PIREG_BW_FW_ED_INTEGpLIMpUP,
	/*58*/	SER_PIREG_BW_FW_ED_INTEGpLIMpDW,
	/*59*/	SER_PIREG_BW_FW_ED_PROP,
	/*60*/	SER_PIREG_BW_FW_ED_INTEG,

			// DCBUS VOLTAGE Regulator Function
	/*61*/	SER_PIREG_BV_FV_VB_REF,
	/*62*/	SER_PIREG_BV_FV_VB_MEAS,
	/*63*/	SER_PIREG_BV_FV_VB_ERR,
	/*64*/	SER_PIREG_BI_FI_VB_LIMpUP,
	/*65*/	SER_PIREG_BI_FI_VB_LIMpDW,
	/*66*/	SER_PIREG_BI_FI_VB_INTEGpLIMpUP,
	/*67*/	SER_PIREG_BI_FI_VB_INTEGpLIMpDW,
	/*68*/	SER_PIREG_BI_FI_VB_PROP,
	/*69*/	SER_PIREG_BI_FI_VB_INTEG,

			// PLL
	/*70*/	SER_PLLT1_BR_FR_REF_ALFA,
	/*71*/	SER_PLLT1_BR_FR_REF_BETA,
	/*72*/	SER_PLLT1_BR_FR_FBK_ALFA,
	/*73*/	SER_PLLT1_BR_FR_FBK_BETA,	 //FBK =Feedback
	/*74*/	SER_PLLT1_BR_FR_ANG_ERRR,
	/*75*/	SER_PLLT1_BR_FR_ERR_INTG,
	/*76*/	SER_PLLT1_BW_FW_EST_FREQ,
	/*77*/	SER_PLLT1_BR_FR_EST_ANGL,

			// Reference Transformation: Voltage
	/*78*/	SER_CLARK_BV_FV_INP_VU,
	/*79*/	SER_CLARK_BV_FV_INP_VV,
	/*80*/	SER_CLARK_BV_FV_INP_VW,
	/*81*/	SER_CLARK_BV_FV_OUT_VALFA,
	/*82*/	SER_CLARK_BV_FV_OUT_VBETA,
	/*83*/	SER_PARKE_BV_FV_OUT_VD,
	/*84*/	SER_PARKE_BV_FV_OUT_VQ,

			// Reference Transformation: Current
	/*85*/	SER_CLARK_BI_FI_INP_IU,
	/*86*/	SER_CLARK_BI_FI_INP_IV,
	/*87*/	SER_CLARK_BI_FI_INP_IW,
	/*88*/	SER_CLARK_BI_FI_OUT_IALFA,
	/*89*/	SER_CLARK_BI_FI_OUT_IBETA,
	/*90*/	SER_PARKE_BI_FI_OUT_ID,
	/*91*/	SER_PARKE_BI_FI_OUT_IQ,

			// Duty Cycle Variable
	/*92*/	SER_DUTY_B1_F1_PWM_DU,
	/*93*/	SER_DUTY_B1_F1_PWM_DV,
	/*94*/	SER_DUTY_B1_F1_PWM_DW,

			// Additional Variable - only for Debug purpose, not for motor control
	/*95*/	SER_DBG_B1_F1_TEST_CNT,

			// PLL TYPE 0 [OLD IMPLEMENATION BUT MODIFIED]
	/*96*/	SER_PLLT0_BV_FV_INP_EpALFA,
	/*97*/	SER_PLLT0_BV_FV_INP_EpBETA,
	/*98*/	SER_PLLT0_BV_FV_EST_EpD,
	/*99*/	SER_PLLT0_BV_FV_EST_EpQ,
	/*100*/	SER_PLLT0_BW_FW_EST_SPD,
	/*101*/	SER_PLLT0_BR_FR_EST_ANG,
	/*102*/	SER_PLLT0_BW_FW_FLT_SPDpEST,

			// PI REGULATORS: Saturation value for integral gain
	/*103*/	SER_PIREG_B1_F1_SAT_KIpID,
	/*104*/	SER_PIREG_B1_F1_SAT_KIpIQ,
	/*105*/	SER_PIREG_B1_F1_SAT_KIpVB,
	/*106*/	SER_PIREG_B1_F1_SAT_KIpED,

			// ADDITIONAL FOR TRANSFORM
	/*107*/	SER_CLARK_BV_FV_OUT_VpALFA,
	/*108*/	SER_CLARK_BV_FV_OUT_VpBETA,

			// ADDITIONAL FOR PLL TYPE1 - NOT USED
	/*109*/	SER_PLLT1_BV_FV_EST_VPHpMOD,

			// REGULATION COMPONENTS OF OUTPUT VOLTAGE
	/*110*/	SER_VOLT_BV_FV_OUT_LSpCOMPpD,
	/*111*/	SER_VOLT_BV_FV_OUT_LSpCOMPpQ,

			// DEADTIME COMPENSATION
	/*112*/	SER_DEADT_BV_FV_VOLT_ERRpD,
	/*113*/	SER_DEADT_BV_FV_VOLT_ERRpQ,
	/*114*/	SER_DEADT_BC_FC_CURR_MODULE,
	/*115*/	SER_DEADT_B1_F1_SECTOR_ASYNC,
	/*116*/	SER_DEADT_BR_FR_ANGLE_SYNC,
	/*117*/	SER_DEADT_BR_FR_ANGLE_ASYNC,
	/*118*/	SER_DEADT_BR_FR_ANGLE_ASYNCpABS,
	/*119*/	SER_DEADT_B1_F1_SECTOR_SYNC,
	/*120*/	SER_DEADT_BV_FV_VOLT_ERRpABS,
	/*121*/	SER_DEADT_BR_FR_ANGLE_ESTpPH,
	/*122*/	SER_DEADT_BV_FV_VOLT_ERRpQpMOD,

			// ADDITIONAL ALGORITHM USED
	/*123*/	SER_RNDIF_BV_FV_DER_VBUS,
	/*124*/	SER_RNDIF_BW_FW_DER_FREQ,
	/*125*/	SER_PHADV_BV_FV_EST_VBUS,

			// INPUT CMD
	/*126*/	SER_SETP_B1_F1_INP_POW,
	/*127*/	SER_SETP_B1_F1_INP_CUR,
	/*128*/	SER_SETP_B1_F1_SPI_POW,
	/*129*/	SER_SETP_B1_F1_SPI_CUR,
	/*130*/ SER_CNTR_BV_FV_INP_DCBUSpSELECT,
	/*131*/ SER_DBG_B1_F1_CNT_STOPpCMD,
	/*132*/	SER_REG_B1_F1_PAR_KPpVOLTAGE,
	/*133*/	SER_REG_B1_F1_PAR_KIpVOLTAGE,

			// Quasi Differential error on vbus measured
	/*134*/ SER_PHADV_BV_FV_ERR_VBUSpMEAS,
	/*135*/ SER_PHADV_BI_FI_ERR_IBUSpCORR,
	/*136*/ SER_DUTY_B1_F1_PWM_DUpDISCRETE,
	/*137*/ SER_DUTY_B1_F1_PWM_DVpDISCRETE,
	/*138*/ SER_DUTY_B1_F1_PWM_DWpDISCRETE,
			// Additional debugging variables
	/*139*/ SER_DBG_B2_F1_STATE_MOTpCNTR,
		} ENUM_SERIAL_CHANNEL;

	ENUM_SERIAL_CHANNEL ch_name[NUM_CHANNELS];
	signed long int *ch_p[NUM_CHANNELS];

	ENUM_SERIAL_CHANNEL ch_LowPrio[NUM_CHANNELS];
	signed long int *ch_pLP[NUM_CHANNELS];


void SerialComm_init(void);
void SerialComm_Handler(void);
void SerialComm_SetSpeedRampParam(unsigned char *);
void SerialComm_Check(void);
unsigned char SerialComm_UpdateParamsLow(void);
void Serial_SetMotorConfiguration(unsigned char *, unsigned char);

void serial_write_packet(const unsigned char *, unsigned char);
unsigned char SerialComm_LoadTxBuff_MotPrm(void);
unsigned char SerialComm_LoadTxBuff_ControlPrm(void);
unsigned char SerialComm_Load_2Byte(unsigned short int, unsigned char);
unsigned char SerialComm_Load_4Byte(signed long int val, unsigned char start_ind);

#endif /* RTE_MY_SETUP_SERIAL_COMMUNICATION_SERIAL_COMMUNICATION_H_ */
