#include<SPI.h>
#include<math.h>


unsigned long transmit = 0.0;

unsigned int inttransmit = 0;  //convert float to 16 bit unsigned int to transmit via spi

unsigned int getback = 0;

//inx
const int IN0 = 6;
const int IN1 = 3;
const int IN2 = A2;
const int IN3 = A3;
const int IN4 = A4;
const int IN5 = A5;

const int pwm2 = 5;
const int pwm3 = 9;

//diag
const int RSTB = A0;  //reset
const int ENB = 7;  //enable
const int FLTB = 8;   //fault flag

const int FLTREF = A1;

//spi
const int CSB = 10;
//sclk is pin 13
//mosi is pin 11
//miso is pin 12
long spispeed = 4000000;

//variables for com with GUI
const byte numChars = 16;
char receivedChars[numChars];
int pwmvalue = 0;
int pwmvalconvert = 0;

static boolean newData = false;
static boolean recvInProgress = false;
static boolean yesspi = false;
static boolean dothespi = false;
static boolean yespwm = false;


  static byte ndx = 0;
  const char startMarker = '<';
  const char endMarker = '>';
  const char spiMarker = '$';

//declaration of functions called throughout program
int spistuff();   //function to transmit spi, 
int todec();
void recvWithStartEndMarkers();
int vfilttodec();

//spi demo stuff
int SPI_DEMO(); //declaration of function

//pwm demo
int PWM_DEMO(); //declaration of function
int pwmDim = 50;
int pwmLoop1 = 0;
int inhold[4] = {IN0, IN1, IN2, IN3};


void setup() {
  Serial.begin(9600);

//declare pinModes
  pinMode(ENB, OUTPUT);
  pinMode(RSTB, OUTPUT);
  pinMode(FLTB, INPUT); //DUT triggers its fault flag on error

  pinMode(CSB, OUTPUT);
  
  //pinMode(FLTR, OUTPUT);  //sends ref voltage via analog pin to fltref

//the INx inputs
  pinMode(IN0, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);
  pinMode(IN5, OUTPUT);
  pinMode(pwm2, OUTPUT);
  pinMode(pwm3, OUTPUT);

  digitalWrite(IN0, LOW);
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, LOW);
  digitalWrite(IN5, LOW);



//voltage filter stuff
  //vfilter should be set to a voltage between 0.35 and 2.75 volts
  //serves as a common reference for all channels
  
//  float vfilterfloat = 0.0;
//  int vfilter = 0;
//  vfilter = map(vfilterfloat, 0.0, 5.0, 0, 255);

  pinMode(CSB, OUTPUT);
  digitalWrite(CSB, HIGH);

  digitalWrite(RSTB, HIGH);
  digitalWrite(ENB, LOW);

 SPI.begin();
 }







void loop() {
     bool start = false;
     newData = false;
     
     while(Serial.available() == 0){};
  
     if (Serial.available() > 0)     {
     recvWithStartEndMarkers();  // Check for serial data
     }
     
     
     // HELLO
  // If the Arduino receives "HELLO" it sends "HELLO" back
  // This is used by the VB program to show it is connected
  
  if (strcmp(receivedChars, "HELLO")  == 0)
  {
    Serial.print("HELLO");
    start = true;
  }

  

while(start == true){

     while(Serial.available() == 0){};

     if (Serial.available() > 0)     {
     recvWithStartEndMarkers();  // Check for serial data
     }

    if(newData == true){
        
        if (dothespi == true){
//          Serial.println("dothe spi");
          todec();
//          Serial.println(inttransmit, BIN);
          getback = spistuff();
          Serial.print(getback);
          dothespi = false;
        }

        }
      
        //in0
           if(strcmp(receivedChars, "a") == 0){
            digitalWrite(IN0, HIGH);
           }
        
           if(strcmp(receivedChars, "b") == 0){
            digitalWrite(IN0, LOW);
           }
         //in1
           if(strcmp(receivedChars, "c") == 0){
            digitalWrite(IN1, HIGH);
           }
        
           if(strcmp(receivedChars, "d") == 0){
            digitalWrite(IN1, LOW);
           }
        //in2
           if(strcmp(receivedChars, "e") == 0){
            digitalWrite(pwm2, HIGH);
            digitalWrite(IN2, HIGH);
           }
        
           if(strcmp(receivedChars, "f") == 0){
            digitalWrite(IN2, LOW);
           }
        //in3
            if(strcmp(receivedChars, "g") == 0){
            digitalWrite(pwm2, HIGH);
            digitalWrite(IN3, HIGH);
           }
        
           if(strcmp(receivedChars, "h") == 0){
            digitalWrite(IN3, LOW);
           }
        
        //in4
           if(strcmp(receivedChars, "i") == 0){
            digitalWrite(pwm3, HIGH);
            digitalWrite(IN4, HIGH);
           }
        
           if(strcmp(receivedChars, "j") == 0){
            digitalWrite(IN4, LOW);
           }
        
        //in5
           if(strcmp(receivedChars, "k") == 0){
            analogWrite(pwm3, 255);
            digitalWrite(IN5, HIGH);
           }
        
           if(strcmp(receivedChars, "l") == 0){
            digitalWrite(IN5, LOW);
           }

        //enable button
        if(strcmp(receivedChars, "m") == 0){
            digitalWrite(ENB, LOW);
           }
        if(strcmp(receivedChars, "n") == 0){
            digitalWrite(ENB, HIGH);
           }

       //reset button
       if(strcmp(receivedChars, "o") == 0){
            digitalWrite(RSTB, LOW);
            delay(300);
            digitalWrite(RSTB, HIGH);
           }
          


       //PWM STUFF
       //easier than adding another character filter
       //4 pwm channels, A B C D
       //each sent with a digiti 1-10
       //should work just as well if not better

       //PWM0 just input 0

        if(strcmp(receivedChars, "A0") == 0){
            digitalWrite(IN0, LOW);
           }
        if(strcmp(receivedChars, "A1") == 0){
            analogWrite(IN0, 25);
           }
        if(strcmp(receivedChars, "A2") == 0){
            analogWrite(IN0, 50);
           }     
        if(strcmp(receivedChars, "A3") == 0){
            analogWrite(IN0, 75);
           }
        if(strcmp(receivedChars, "A4") == 0){
            analogWrite(IN0, 100);
           }
        if(strcmp(receivedChars, "A5") == 0){
            analogWrite(IN0, 125);
           }     
        if(strcmp(receivedChars, "A6") == 0){
            analogWrite(IN0, 150);
           }
        if(strcmp(receivedChars, "A7") == 0){
            analogWrite(IN0, 175);
           }
        if(strcmp(receivedChars, "A8") == 0){
            analogWrite(IN0, 200);
           }
        if(strcmp(receivedChars, "A9") == 0){
            analogWrite(IN0, 225);
           }     
        if(strcmp(receivedChars, "A10") == 0){
            analogWrite(IN0, 255);
           }



        //PWM1 just input 1

        if(strcmp(receivedChars, "B0") == 0){
            digitalWrite(IN1, LOW);
           }
        if(strcmp(receivedChars, "B1") == 0){
            analogWrite(IN1, 25);
           }
        if(strcmp(receivedChars, "B2") == 0){
            analogWrite(IN1, 50);
           }     
        if(strcmp(receivedChars, "B3") == 0){
            analogWrite(IN1, 75);
           }
        if(strcmp(receivedChars, "B4") == 0){
            analogWrite(IN1, 100);
           }
        if(strcmp(receivedChars, "B5") == 0){
            analogWrite(IN1, 125);
           }     
        if(strcmp(receivedChars, "B6") == 0){
            analogWrite(IN1, 150);
           }
        if(strcmp(receivedChars, "B7") == 0){
            analogWrite(IN1, 175);
           }
        if(strcmp(receivedChars, "B8") == 0){
            analogWrite(IN1, 200);
           }
        if(strcmp(receivedChars, "B9") == 0){
            analogWrite(IN1, 225);
           }     
        if(strcmp(receivedChars, "B10") == 0){
            analogWrite(IN1, 255);
           }

        
        
        //PWM2 just INs 2 and 3

        if(strcmp(receivedChars, "C0") == 0){
            digitalWrite(pwm2, LOW);
           }
        if(strcmp(receivedChars, "C1") == 0){
            analogWrite(pwm2, 25);
           }
        if(strcmp(receivedChars, "C2") == 0){
            analogWrite(pwm2, 50);
           }     
        if(strcmp(receivedChars, "C3") == 0){
            analogWrite(pwm2, 75);
           }
        if(strcmp(receivedChars, "C4") == 0){
            analogWrite(pwm2, 100);
           }
        if(strcmp(receivedChars, "C5") == 0){
            analogWrite(pwm2, 125);
           }     
        if(strcmp(receivedChars, "C6") == 0){
            analogWrite(pwm2, 150);
           }
        if(strcmp(receivedChars, "C7") == 0){
            analogWrite(pwm2, 175);
           }
        if(strcmp(receivedChars, "C8") == 0){
            analogWrite(pwm2, 200);
           }
        if(strcmp(receivedChars, "C9") == 0){
            analogWrite(pwm2, 225);
           }     
        if(strcmp(receivedChars, "C10") == 0){
            analogWrite(pwm2, 255);
           }
        
        if(strcmp(receivedChars, "CIN2ON") == 0){
          digitalWrite(IN2, HIGH);
        }

        if(strcmp(receivedChars, "CIN2OFF") == 0){
          digitalWrite(IN2, LOW);
        }

        if(strcmp(receivedChars, "CIN3ON") == 0){
          digitalWrite(IN3, HIGH);
        }

        if(strcmp(receivedChars, "CIN3OFF") == 0){
          digitalWrite(IN3, LOW);
        }



        //pwm 3 INs 4 and 5
        
        if(strcmp(receivedChars, "D0") == 0){
            digitalWrite(pwm3, LOW);
           }
        if(strcmp(receivedChars, "D1") == 0){
            analogWrite(pwm3, 25);
           }
        if(strcmp(receivedChars, "D2") == 0){
            analogWrite(pwm3, 50);
           }     
        if(strcmp(receivedChars, "D3") == 0){
            analogWrite(pwm3, 75);
           }
        if(strcmp(receivedChars, "D4") == 0){
            analogWrite(pwm3, 100);
           }
        if(strcmp(receivedChars, "D5") == 0){
            analogWrite(pwm3, 125);
           }     
        if(strcmp(receivedChars, "D6") == 0){
            analogWrite(pwm3, 150);
           }
        if(strcmp(receivedChars, "D7") == 0){
            analogWrite(pwm3, 175);
           }
        if(strcmp(receivedChars, "D8") == 0){
            analogWrite(pwm3, 200);
           }
        if(strcmp(receivedChars, "D9") == 0){
            analogWrite(pwm3, 225);
           }     
        if(strcmp(receivedChars, "D10") == 0){
            analogWrite(pwm3, 255);
           }
        
        if(strcmp(receivedChars, "CIN4ON") == 0){
          digitalWrite(IN4, HIGH);
        }

        if(strcmp(receivedChars, "CIN4OFF") == 0){
          digitalWrite(IN4, LOW);
        }

        if(strcmp(receivedChars, "CIN5ON") == 0){
          digitalWrite(IN5, HIGH);
        }

        if(strcmp(receivedChars, "CIN5OFF") == 0){
          digitalWrite(IN5, LOW);
        }


        //spi demo call

        if(strcmp(receivedChars, "SPIDEMOSTART") == 0){
          //Serial.println("SPI DEMO STARTED");
          SPI_DEMO();
          memset(receivedChars,0,numChars);
        }

        

        if(strcmp(receivedChars, "PWMDEMOSTART") == 0){
          //Serial.println("PWM DEMO STARTED");
          PWM_DEMO();
          memset(receivedChars,0,numChars);
        }

      //vfilt call

      if(strcmp(receivedChars, "Z") == 0){
          int vfilter = analogRead(FLTREF);
          vfilter = vfilter + 9;  //accounts for a difference between the arduino's read and the DMM read
          //delay(100);
          vfilter = map(vfilter, 0, 1023, 0, 255);  //maps the 16 bits to 8 bits
                                                    //slightly less accurate, but allows for us to transmit over the same serial setup
          
          long nibble = 0;

          nibble = 65280; //binary 1111 1111 0000 0000
                          //in order to not have to entirely reconstruct the VS program, 
                          //it is easiest to send this value as a 16 bit number 
                          //and just subtract the 65280 back off of it after
                          
          nibble = nibble + vfilter;  //since the value is already 1111 1111 0000 0000 
                                      //whats being added to the value is in the range of 0000 0000 xxxx xxxx
                                      //in VS program, 1111 1111 0000 0000 will be subtracted and the value can be manipulated
                                      //to be multiplied by 5/255
                                      //
                                      //ex. voltage of 2V
                                      //arduino will read as binary between 0 and 1023 (ex, 409)
                                      //map that to binary between 0 and 255 (ex, 102, 0110 0110)
                                      //add 65280 (1111 1111 0000 0000) to it (1111 1111 0110 0110 or 65382)
                                      //send 16 bit over serial 
                                      //if greater than or equal to 65280 (which this will be), will take last 8 bits and turn it into 0 - 255 (back to 102)
                                      //take that value and multiply it by 5/255 (the ratio, appx 0.01961) (2)
                                      //result is vfilt value in VS program (2.0)
          
          Serial.print(nibble);
          memset(receivedChars,0,numChars);

          //delay(100);
      }











      newData = false;
    } //while start = true

  } //loop
  

  

  

  


 


void recvWithStartEndMarkers()
{
  char rc;
//set read character to serial read, the function is only called when serial.available is true, so no need to call it
  rc = Serial.read();

//begin the read of the string by checking if its the start marker
//whenever there is a start marker, the program will start reading it as a new entry
//    therefore no transmissions should contain a "<" between the markers
  
  if(rc == endMarker){
    newData = true;
    recvInProgress = false;
    
    if(yesspi == true){
    dothespi = true;
    yesspi = false;

//    Serial.println("End");
    }
    
  }
    
  else if (rc != endMarker && rc != startMarker && rc != spiMarker){
    if(yesspi == true){
    int bin;
      if (rc == 48){
        receivedChars[ndx] = '0';
      }
      else if (rc == 49){
        receivedChars[ndx] = '1';
      }

//      Serial.print(receivedChars[ndx]);
    }
    
    else if(yesspi != true){
    receivedChars[ndx] = rc;
    }
    
    ndx++; //this needs to be within the brackets for the else if part with all of the !=, just a reminder after spending an hour wondering why SPI stopped transmitting correctly
       
   
}

  else if (rc == spiMarker){
      yesspi = true;

//      Serial.println("spi marker");
    }

  else if(rc == startMarker){
    ndx = 0;
    memset(receivedChars,0,numChars);
    recvInProgress = true;

//    Serial.println("start");
  }

  

  
  }



















