/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * main.c                                                                      *
 * Code for NCV7381B Evaluation Board                                          *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/
 
/* Common defines and macros */
#include <hidef.h>

/* S12X derivative information */ 
#include "mc9s12xf512.h"   

#include <string.h>
#include "xgate.h"

/* Variable types and common definitions */
#include "typedefs.h"    

/* CPU definitions */
#include "Cpu.h"

/* Interrupt service routines prototypes */
#include "Interrupts.h"

/* Macro definitions for general purpose I/O handling    */
#include "GPIO_macros.h"

/* ADC routines definition */
#include "ADC.h"

/* Serial communication interface SCI0                   */
#include "SCI0.h"

/* Host communication module                             */
#include "HostComm.h"   

/* CAN channel definitions and function prototypes       */
#include "CAN.h"

/* FlexRay communication controller function prototypes */
#include "FlexRay_CC.h"

/* Flexray bus driver function prototypes */
#include "FlexRay_BD.h"

/*******************************************************************************/

#pragma push

#pragma DATA_SEG SHARED_DATA
volatile int shared_counter; /* volatile because both cores are accessing it. */

/* Two stacks in XGATE core3 */ 
#pragma DATA_SEG XGATE_STK_L
word XGATE_STACK_L[1]; 
#pragma DATA_SEG XGATE_STK_H
word XGATE_STACK_H[1];

#pragma pop

#define ROUTE_INTERRUPT(vec_adr, cfdata)                \
  INT_CFADDR= (vec_adr) & 0xF0;                         \
  INT_CFDATA_ARR[((vec_adr) & 0x0F) >> 1]= (cfdata)

#define SOFTWARETRIGGER0_VEC  0x72 /* vector address= 2 * channel id */

static void SetupXGATE(void) {
  /* initialize the XGATE vector block and
     set the XGVBR register to its start address */
  XGVBR= (unsigned int)(void*__far)(XGATE_VectorTable - XGATE_VECTOR_OFFSET);

  /* switch software trigger 0 interrupt to XGATE */
  ROUTE_INTERRUPT(SOFTWARETRIGGER0_VEC, 0x81); /* RQST=1 and PRIO=1 */

  /* when changing your derivative to non-core3 one please remove next five lines */
  XGISPSEL= 1;
  XGISP31= (unsigned int)(void*__far)(XGATE_STACK_L + 1);
  XGISPSEL= 2;
  XGISP74= (unsigned int)(void*__far)(XGATE_STACK_H + 1);
  XGISPSEL= 0;

  /* enable XGATE mode and interrupts */
  XGMCTL= 0xFBC1; /* XGE | XGFRZ | XGIE */

  /* force execution of software trigger 0 handler */
  XGSWT= 0x0101;
}

/*******************************************************************************/
word aux;
Fr_POC_state_type POC_state;  


void main(void) {
 
    SetupXGATE();

    Clock_Settings();       /* System clock and PLL initialization */ 
    IPLL_Startup();         /* FlexRay IPLL initialization */
    Peripheral_Settings();  /* CPU, memory and ports settings */     
    Interrupts_Init();      /* Interrupts configuration */               
    FlexRay_CC_initialized = FALSE;
    PIT_Init();             /* PIT module initialization (Programmable Interrupt Timer) */  
    FlexRay_Init();         /* FlexRay module configuration */
    SCI0_init();            /* SCI module initialization */  
    CAN_init(0x00FF & (word)SW_ADDRESS);          /* Initialize MSCAN module */ 
    ADC_init();             /* ADC module initialization */
    hostcomm_initialize (); /* initialization of the host communication */
     
    ENABLE_INTERRUPTS();
    EnableCAN_BD();         /* Enable CAN transceiver (STB = 1) */
    
    /* Set voltage regulators to be set by FR BD INH pin*/
    INH_VCC_DISABLE = 0;
    INH_VIO_DISABLE = 0;

  
    for (;;){   /* Endless loop,waiting for interrupts */     
      hostcomm_process_SCI0 ();
      hostcomm_process_CAN ();
      POC_state = Fr_get_POC_state();
      //WAIT(); 
    }; 
}
