/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * Vectors.c                                                                   *
 * Interrupt service routines definition                                       *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

/* S12X derivative information */ 
#include "mc9s12xf512.h"   

/* Interrupt service routines prototypes */ 
#include "Interrupts.h"

/* Serial communication interface prototypes */ 
#include "SCI0.h"

/* ADC interface prototypes */ 
#include "ADC.h"

/* CAN channel definitions and function prototypes  */
#include "CAN.h"

/* Startup defined in Start12.c */
extern void interrupt  _Startup(void);

/*******************************************************************************/

/* Dummy Interrupt Service Routine */
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt Dummy_Isr()
{
    
}

/*******************************************************************************/

/* Interrupt vectors table */
typedef void (*near tIsrFunc)(void);
const tIsrFunc _InterruptVectorTable[] @0xFF10 = {
  /* ISR name             No.   Address  Pri XGATE Name            */  
  Dummy_Isr,           /* 0x08  0xFF10   -   -     ivVsi           */
  Dummy_Isr,           /* 0x09  0xFF12   -   -     ivReserved119   */
  Dummy_Isr,           /* 0x0A  0xFF14   -   -     ivReserved118   */
  Dummy_Isr,           /* 0x0B  0xFF16   -   no    ivReserved117   */
  Dummy_Isr,           /* 0x0C  0xFF18   1   no    ivReserved116   */
  Dummy_Isr,           /* 0x0D  0xFF1A   1   no    ivReserved115   */
  Dummy_Isr,           /* 0x0E  0xFF1C   1   no    ivReserved114   */
  Dummy_Isr,           /* 0x0F  0xFF1E   1   no    ivReserved113   */
  Dummy_Isr,           /* 0x10  0xFF20   1   no    ivReserved112   */
  Dummy_Isr,           /* 0x11  0xFF22   1   no    ivReserved111   */
  Dummy_Isr,           /* 0x12  0xFF24   1   no    ivReserved110   */
  Dummy_Isr,           /* 0x13  0xFF26   1   no    ivReserved109   */
  Dummy_Isr,           /* 0x14  0xFF28   1   no    ivReserved108   */
  Dummy_Isr,           /* 0x15  0xFF2A   1   no    ivReserved107   */
  Dummy_Isr,           /* 0x16  0xFF2C   1   no    ivReserved106   */
  Dummy_Isr,           /* 0x17  0xFF2E   1   no    ivReserved105   */
  Dummy_Isr,           /* 0x18  0xFF30   1   no    ivReserved104   */
  Dummy_Isr,           /* 0x19  0xFF32   1   no    ivReserved103   */
  Dummy_Isr,           /* 0x1A  0xFF34   1   no    ivReserved102   */
  Dummy_Isr,           /* 0x1B  0xFF36   1   no    ivReserved101   */
  Dummy_Isr,           /* 0x1C  0xFF38   1   no    ivReserved100   */
  Dummy_Isr,           /* 0x1D  0xFF3A   1   no    ivReserved99    */
  Dummy_Isr,           /* 0x1E  0xFF3C   1   no    ivReserved98    */
  Dummy_Isr,           /* 0x1F  0xFF3E   1   no    ivReserved97    */
  Dummy_Isr,           /* 0x20  0xFF40   1   no    ivReserved96    */
  Dummy_Isr,           /* 0x21  0xFF42   1   no    ivReserved95    */
  Dummy_Isr,           /* 0x22  0xFF44   1   no    ivReserved94    */
  Dummy_Isr,           /* 0x23  0xFF46   1   no    ivReserved93    */
  Dummy_Isr,           /* 0x24  0xFF48   1   no    ivReserved92    */
  Dummy_Isr,           /* 0x25  0xFF4A   1   no    ivReserved91    */
  Dummy_Isr,           /* 0x26  0xFF4C   1   no    ivReserved90    */
  Dummy_Isr,           /* 0x27  0xFF4E   1   no    ivReserved89    */
  Dummy_Isr,           /* 0x28  0xFF50   1   no    ivReserved88    */
  Dummy_Isr,           /* 0x29  0xFF52   1   no    ivReserved87    */
  Dummy_Isr,           /* 0x2A  0xFF54   1   no    ivReserved86    */
  Dummy_Isr,           /* 0x2B  0xFF56   1   no    ivReserved85    */
  Dummy_Isr,           /* 0x2C  0xFF58   1   no    ivReserved84    */
  Dummy_Isr,           /* 0x2D  0xFF5A   1   no    ivReserved83    */
  Dummy_Isr,           /* 0x2E  0xFF5C   1   no    ivReserved82    */
  Dummy_Isr,           /* 0x2F  0xFF5E   1   no    ivReserved81    */
  Dummy_Isr,           /* 0x30  0xFF60   1   no    ivVxsramav      */
  Dummy_Isr,           /* 0x31  0xFF62   1   no    ivVxsei         */
  Dummy_Isr,           /* 0x32  0xFF64   1   no    ivVxst7         */
  Dummy_Isr,           /* 0x33  0xFF66   1   no    ivVxst6         */
  Dummy_Isr,           /* 0x34  0xFF68   1   no    ivVxst5         */
  Dummy_Isr,           /* 0x35  0xFF6A   1   no    ivVxst4         */
  Dummy_Isr,           /* 0x36  0xFF6C   1   no    ivVxst3         */
  Dummy_Isr,           /* 0x37  0xFF6E   1   no    ivVxst2         */
  Dummy_Isr,           /* 0x38  0xFF70   1   no    ivVxst1         */
  Dummy_Isr,           /* 0x39  0xFF72   1   no    ivVxst0         */
  Dummy_Isr,           /* 0x3A  0xFF74   1   no    ivVpit3         */
  Dummy_Isr,           /* 0x3B  0xFF76   1   no    ivVpit2         */
  Dummy_Isr,           /* 0x3C  0xFF78   1   no    ivVpit1         */
  Dummy_Isr,           /* 0x3D  0xFF7A   1   no    ivVpit0         */
  Dummy_Isr,           /* 0x3E  0xFF7C   1   -     ivVReserved65   */
  Dummy_Isr,           /* 0x3F  0xFF7E   1   no    ivVapi          */
  Dummy_Isr,           /* 0x40  0xFF80   1   no    ivVlvi          */
  Dummy_Isr,           /* 0x41  0xFF82   1   no    ivVReserved62   */
  Dummy_Isr,           /* 0x42  0xFF84   1   no    ivVReserved61   */
  Dummy_Isr,           /* 0x43  0xFF86   1   no    ivVReserved60   */
  Dummy_Isr,           /* 0x44  0xFF88   1   no    ivVReserved59   */
  Dummy_Isr,           /* 0x45  0xFF8A   1   no    ivVReserved58   */
  Dummy_Isr,           /* 0x46  0xFF8C   1   no    ivVpmffault3    */
  Dummy_Isr,           /* 0x47  0xFF8E   1   no    ivVpmffault2    */
  Dummy_Isr,           /* 0x48  0xFF90   1   no    ivVpmffault1    */
  Dummy_Isr,           /* 0x49  0xFF92   1   no    ivVpmffault0    */
  Dummy_Isr,           /* 0x4A  0xFF94   1   no    ivVpmfgcr       */
  Dummy_Isr,           /* 0x4B  0xFF96   1   no    ivVpmfgbr       */
  Dummy_Isr,           /* 0x4C  0xFF98   1   no    ivVpmfgar       */
  FLEXRAY_Protocol_Isr,/* 0x4D  0xFF9A   1   no    ivVfrprot       */
  Dummy_Isr,           /* 0x4E  0xFF9C   1   no    ivVfrchi        */
  FLEXRAY_Wakeup_Isr,  /* 0x4F  0xFF9E   1   no    ivVfrwakeup     */
  Dummy_Isr,           /* 0x50  0xFFA0   1   no    ivVfrrxfifob    */
  Dummy_Isr,           /* 0x51  0xFFA2   1   no    ivVfrrxfifoa    */
  FLEXRAY_RX_Isr,      /* 0x52  0xFFA4   1   no    ivVfrrxmessbuff */
  FLEXRAY_TX_Isr,      /* 0x53  0xFFA6   1   no    ivVfrtxmessbuff */
  Dummy_Isr,           /* 0x54  0xFFA8   1   no    ivVReserved43   */
  Dummy_Isr,           /* 0x55  0xFFAA   1   no    ivVReserved42   */
  Dummy_Isr,           /* 0x56  0xFFAC   1   no    ivVReserved41   */
  Dummy_Isr,           /* 0x57  0xFFAE   1   no    ivVReserved40   */
  CAN0_TX_Isr,         /* 0x58  0xFFB0   1   no    ivVcan0tx       */
  CAN0_RX_Isr,         /* 0x59  0xFFB2   1   no    ivVcan0rx       */
  CAN0_ERR_Isr,        /* 0x5A  0xFFB4   1   no    ivVcan0err      */
  Dummy_Isr,           /* 0x5B  0xFFB6   1   no    ivVcan0wkup     */
  Dummy_Isr,           /* 0x5C  0xFFB8   1   no    ivVflash        */
  Dummy_Isr,           /* 0x5D  0xFFBA   1   no    ivVeeprom       */
  Dummy_Isr,           /* 0x5E  0xFFBC   1   no    ivVReserved33   */
  Dummy_Isr,           /* 0x5F  0xFFBE   1   no    ivVspi1         */
  Dummy_Isr,           /* 0x60  0xFFC0   1   no    ivVReserved31   */
  Dummy_Isr,           /* 0x61  0xFFC2   1   no    ivVReserved30   */
  Dummy_Isr,           /* 0x62  0xFFC4   1   no    ivVcrgscm       */
  Dummy_Isr,           /* 0x63  0xFFC6   1   no    ivVcrgplllck    */
  Dummy_Isr,           /* 0x64  0xFFC8   1   no    ivVtimpabovf    */
  Dummy_Isr,           /* 0x65  0xFFCA   1   no    ivVtimmdcu      */
  Dummy_Isr,           /* 0x66  0xFFCC   1   no    ivVReserved25   */
  Dummy_Isr,           /* 0x67  0xFFCE   1   no    ivVReserved24   */
  ADC_Conv_Compl_Isr,  /* 0x68  0xFFD0   1   no    ivVatd          */
  Dummy_Isr,           /* 0x69  0xFFD2   1   no    ivVReserved22   */
  Dummy_Isr,           /* 0x6A  0xFFD4   1   no    ivVsci1         */
  SCI0_Isr,            /* 0x6B  0xFFD6   1   no    ivVsci0         */
  Dummy_Isr,           /* 0x6C  0xFFD8   1   no    ivVspi0         */
  Dummy_Isr,           /* 0x6D  0xFFDA   1   no    ivVtimpaie      */
  Dummy_Isr,           /* 0x6E  0xFFDC   1   no    ivVtimpaaovf    */
  Dummy_Isr,           /* 0x6F  0xFFDE   1   no    ivVtimovf       */
  Dummy_Isr,           /* 0x70  0xFFE0   1   no    ivVtimch7       */
  Dummy_Isr,           /* 0x71  0xFFE2   1   no    ivVtimch6       */
  Dummy_Isr,           /* 0x72  0xFFE4   1   no    ivVtimch5       */
  Dummy_Isr,           /* 0x73  0xFFE6   1   no    ivVtimch4       */
  Dummy_Isr,           /* 0x74  0xFFE8   4   no    ivVtimch3       */
  Dummy_Isr,           /* 0x75  0xFFEA   1   no    ivVtimch2       */
  Dummy_Isr,           /* 0x76  0xFFEC   1   no    ivVtimch1       */
  Dummy_Isr,           /* 0x77  0xFFEE   1   no    ivVtimch0       */
  RTI_Isr,             /* 0x78  0xFFF0   1   no    ivVrti          */
  External_IRQ_Isr,    /* 0x79  0xFFF2   1   no    ivVirq          */
  Dummy_Isr,           /* 0x7A  0xFFF4   -   -     ivVxirq         */
  Dummy_Isr,           /* 0x7B  0xFFF6   -   -     ivVswi          */
  Dummy_Isr            /* 0x7C  0xFFF8   -   -     ivVtrap         */
};

/* Reset vector table */
const tIsrFunc _ResetVectorTable[] @0xFFFA = { 
  /* Reset handler name        Address            Name            */
  _Startup,           /*       0xFFFA             ivVcop          */
  Dummy_Isr,          /*       0xFFFC             ivVclkmon       */
  //_Startup          /*       0xFFFE             ivVreset        */
};

#pragma CODE_SEG DEFAULT
/*******************************************************************************/

