
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * typedefs.h                                                                  *
 * Variable types and common macros                                            *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

/* Types definition */
typedef unsigned char bool;

typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned long UINT32;
typedef signed char   INT8;   
typedef short         INT16;  
typedef long int      INT32;

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

typedef void (*tIntFunc)(void);

/*  Common Constants */          
#ifndef TRUE
  #define TRUE (bool) 1
#endif
#ifndef FALSE
  #define FALSE (bool) 0
#endif

#define ON      bool 1
#define OFF     bool 0




typedef byte TBUFFER_DATA; // data type for the communication buffers (will be shared among several modules)

/*This macro saves CCR register and disable global interrupts. */
#define EnterCritical()     { __asm pshc; __asm sei; __asm movb 1,SP+,CCR_reg; } 
/* This macro restores CCR register saved in SaveStatusReg(). */
#define ExitCritical()  { __asm movb CCR_reg, 1,-SP; __asm pulc; } 

/* Constants for detecting running mode */
#define HIGH_SPEED        0            /* High speed */
#define LOW_SPEED         1            /* Low speed */
#define SLOW_SPEED        2            /* Slow speed */

/* Reset cause constants */
#define RSTSRC_POR        1            /* Power-on reset        */
#define RSTSRC_PIN        8            /* External reset bit    */
#define RSTSRC_COP        4            /* COP reset             */
#define RSTSRC_ILOP       2            /* Illegal opcode reset  */
#define RSTSRC_ILAD       16           /* Illegal address reset */
#define RSTSRC_LVI        32           /* Low voltage inhibit reset */

/* Common Bit masks */
#define ENABLE_INTERRUPTS()  {__asm CLI; XGMCTL_XGIE = 1;}        /*interrupts enabled        */
#define DISABLE_INTERRUPTS() {__asm SEI; XGMCTL_XGIE = 0;}        /*interrupts disabled       */
#define XIRQ_ENABLE()        {asm andcc #0xBF;}  /*XIRQ enabled              */
#define WAIT()               {asm wai;}          /*enter wait mode           */
#define STOP_ENABLE()        {asm andcc #0x7F;}  /*stop mode enabled         */
#define STOP()               {asm stop;}         /*enter stop mode           */
#define NOP()                {asm nop;}          /*enter NOP asm instruction */

/* ERROR types definition */
#define ERR_OK           0             /* OK */
#define ERR_SPEED        1             /* This device does not work in the active speed mode. */
#define ERR_RANGE        2             /* Parameter out of range. */
#define ERR_VALUE        3             /* Parameter of incorrect value. */
#define ERR_OVERFLOW     4             /* Timer overflow. */
#define ERR_MATH         5             /* Overflow during evaluation. */
#define ERR_ENABLED      6             /* Device is enabled. */
#define ERR_DISABLED     7             /* Device is disabled. */
#define ERR_BUSY         8             /* Device is busy. */
#define ERR_NOTAVAIL     9             /* Requested value or method not available. */
#define ERR_RXEMPTY      10            /* No data in receiver. */
#define ERR_TXFULL       11            /* Transmitter is full. */
#define ERR_BUSOFF       12            /* Bus not available. */
#define ERR_OVERRUN      13            /* Overrun error is detected. */
#define ERR_FRAMING      14            /* Framing error is detected. */
#define ERR_PARITY       15            /* Parity error is detected. */
#define ERR_NOISE        16            /* Noise error is detected. */
#define ERR_IDLE         17            /* Idle error is detected. */
#define ERR_FAULT        18            /* Fault error is detected. */
#define ERR_BREAK        19            /* Break char is received during communication. */
#define ERR_CRC          20            /* CRC error is detected. */
#define ERR_ARBITR       21            /* A node losts arbitration. This error occurs if two nodes start transmission at the same time. */
#define ERR_PROTECT      22            /* Protection error is detected. */
#define ERR_UNDERFLOW    23            /* Underflow error is detected. */
#define ERR_UNDERRUN     24            /* Underrun error is detected. */
#define ERR_COMMON       25            /* Common error of a device. */
#define ERR_LINSYNC      26            /* LIN synchronization error is detected. */

/* Signal for Bus Driver transition to SLEEP mode */
#define BD_GO_TO_SLEEP   200
#define BD_NORMAL_OPERATION 1

/* UART Communication Buffers */
#define SIZE_COMM_BUFFERS      0x80   // 128 B, including header

#define BAUDRATE 19200

/* UART Communication Buffers */
#define SIZE_CAN_BUFFERS       0x80   // 128 B, including header



/*******************************************************************************/




