/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Scheduler.c
\brief      Task scheduler.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.3
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "mc9s12xf512.h"      

/** Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/** Variable types and common definitions */
#include "typedefs.h"   

#include "FlexRay_BD.h"  

#include "CAN_driver.h" 

/** Error flag for CAN transmission*/
//UINT8 u8ErrorFlag = NO_ERR;
    
/** Transmission buffer */
UINT8 u8TxBuffer[] = "S12XF512";


/*******************************************************************************/
//    Scheduler - RTI service routine
/*******************************************************************************/
UINT8 u8Scheduler(UINT8 u8Task)
{      
    bool x;
    //Fr_bd_status_register Status;
    CRGFLG_RTIF = 1;       /* Clear the real time interrupt flag */        
    
        switch (u8Task)    /* Scheduler */
        {
            case 2:                                          
                x=PTP_PTP0;
                PTP >>= 1;
                PTP_PTP7 = x;
                
                
                //{asm ROR PTP ;}    
                break;
                
            case 4:
                         
                break;
                
            case 6:               
                u8Task = 0;     /* Initialize the task code */                                              
                break;
                
            default:   
                break;  
        }
        
        return u8Task+1;        /* Update the task code */                
}

/*******************************************************************************/