
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * SCI0.c                                                                      *
 * Serial communication interface SCI0                                         *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

// PROTOCOL:
// This module implements the transmission level of the host communication protocol. See documentation for details.

// NOTES:
// - Structure of the frame: LENGTH (1B) + DATA.
//   Length determines the length of the data payload. The length byte is not included.
// - Frame encoding [adding the header byte] is done internally in this UART0 module. Clients see only the data in both the TX and RX buffer.
// - Both buffers (TX and RX) are accessible directly. Having internal buffers would be wasting of memory.
//   On the other hand, there is no way to prevent corruption of the data by external code, so be careful.

#include "Cpu.h"
#include "typedefs.h"

#pragma DATA_SEG SCI0_DATA
#pragma CODE_SEG SCI0_CODE

/*** Buffers ***/
#define SIZE_RXBUF   SIZE_COMM_BUFFERS  // Input buffer size
#define SIZE_TXBUF   SIZE_COMM_BUFFERS  // Output buffer size

extern byte SCI0_rxlen;              /* Length of output bufer's content */
extern byte SCI0_txlen;              /* Length of input buffer's content */

/*** Buffers ***/
extern TBUFFER_DATA SCI0_rxdata[SIZE_RXBUF];   /* reception data buffer  */
extern TBUFFER_DATA SCI0_txdata[SIZE_TXBUF];   /* transmission data buffer */

/*** Data Reception ***/
byte  SCI0_received (void);          /* data reception finished */
void SCI0_rxprocessed (void);        /* received data processed, get ready for next frame */

/*** Data Transmission ***/
void SCI0_transmit (void);           /* request to transmit data in the TX buffer */
byte  SCI0_txactive (void);          /* transmission in progress */

/*** Break signal detection ***/
byte SCI0_GetBreak(byte *Brk);       /* Tests the internal input break flag and returns it */

/*** Break signal transmission ***/
byte SCI0_SetBreak(void);            /* Sends the break sequence to the output line */

/*** Reset SCI0 buffer registers. Resyncronize frame reception ***/
void SCI0_OnError(void);

/*** Interrupt ***/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt SCI0_Isr(void);
#pragma CODE_SEG SCI0_CODE

/*** Initialization ***/
void SCI0_init(void);          // initialization of the serial port and the UART baudrate

#pragma CODE_SEG DEFAULT
