/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * Interrupts.c                                                                *
 * Interrupt service routine functions                                         *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

/* S12X derivative information */ 
#include "mc9s12xf512.h"     

/* Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/* Variable types and common definitions */
#include "typedefs.h"   

/* UNIFIED driver implementation */         
#include "Fr_UNIFIED.h"

/* FlexRay communication controller function prototypes */
#include "FlexRay_BD.h" 

/* FlexRay bus driver function prototypes */
#include "FlexRay_CC.h" 

/* CAN channel definitions and function prototypes  */
#include "CAN.h"

/* CPU definitions */
#include "cpu.h"



/* Auxiliary variables */
word pwm_ratio = 0;
byte counter;
byte ext_flag; 
byte LED_mode;
Fr_bd_status_register Status;
bool read_status;

#define BTN_DEBOUNCE_LED 20
#define BTN_DEBOUNCE_SLEEP 70

/*******************************************************************************/
/* Real Time Interrupt service routine                                         */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt RTI_Isr(void)
{     
    CRGFLG_RTIF = 1;    /* Clear the real time interrupt flag */  
    //XGSWT= 0x0101;      /* Software trigger to the XGATE */
    
    if (BTN2 == 1) counter = 0; 
    else if (counter < BTN_DEBOUNCE_SLEEP) counter++;
    
    if (counter == BTN_DEBOUNCE_LED) {
      counter++;
      LED_mode++;
      read_status = TRUE;           
    }    
    if (counter == BTN_DEBOUNCE_SLEEP) {
      counter++;
      tx_data[0][0] = BD_GO_TO_SLEEP;
    }
    
    switch (LED_mode) {
      case 0: 
        if (LEDS & LED1_MASK) LED1 ^= LED1_MASK;
        if (LEDS & LED2_MASK) LED2 ^= LED2_MASK;
        if (LEDS & LED3_MASK) LED3 ^= LED3_MASK;
        if (LEDS & LED4_MASK) LED4 ^= LED4_MASK;
        if (LEDS & LED5_MASK) LED5 ^= LED5_MASK; 
        LEDS = 0;
        break;
      case 1: 
        if (read_status){           
          Status = fr_bd_read_status(FR_CHANNEL_A);
          read_status = FALSE;
        }
        LED1 = (byte)Status.Flags.Bits.LocalWakeUp;  
        LED2 = (byte)Status.Flags.Bits.RemoteWakeUp;  
        LED3 = (byte)Status.Flags.Bits.TxenBgeTimeout;
        LED4 = (byte)Status.Flags.Bits.BusError;
        LED5 = (byte)Status.Flags.Bits.VioUV;
        LED6 = (byte)Status.Flags.Bits.VccUV;
        LED7 = (byte)Status.Flags.Bits.VbatUV;
        LED8 = (byte)Status.Flags.Bits.PowerOn;
        break;
      case 2: 
        if (read_status){           
          Status = fr_bd_read_status(FR_CHANNEL_B);
          read_status = FALSE;
        }
        LED1 = (byte)Status.Flags.Bits.LocalWakeUp;  
        LED2 = (byte)Status.Flags.Bits.RemoteWakeUp;  
        LED3 = (byte)Status.Flags.Bits.TxenBgeTimeout;
        LED4 = (byte)Status.Flags.Bits.BusError;
        LED5 = (byte)Status.Flags.Bits.VioUV;
        LED6 = (byte)Status.Flags.Bits.VccUV;
        LED7 = (byte)Status.Flags.Bits.VbatUV;
        LED8 = (byte)Status.Flags.Bits.PowerOn;
        break;  
      default: 
        LEDS_ADDRESS &= 0b11100000;
        LED_mode = 0; 
        break;
    }   
}
#pragma CODE_SEG RTI_ISR_CODE


/*******************************************************************************/
/* External IRQ Interrupt Service Routine                                      */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt External_IRQ_Isr(void)
{
  read_status = TRUE;  
}
#pragma CODE_SEG EXTERNAL_IRQ_ISR_CODE


/*******************************************************************************/
/* FlexRay Transmission Message Buffer Interrupt Service Routine               */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt FLEXRAY_TX_Isr(void)
{   
    Fr_interrupt_handler(); 
}
#pragma CODE_SEG FLEXRAY_TX_ISR_CODE 

/*******************************************************************************/
/* FlexRay Reception Message Buffer Interrupt Service Routine                  */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt FLEXRAY_RX_Isr(void)
{          
    Fr_interrupt_handler();  
}
#pragma CODE_SEG FLEXRAY_RX_ISR_CODE

/*******************************************************************************/
/* FlexRay Remote WakeUp Interrupt Service Routine                             */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt FLEXRAY_Wakeup_Isr(void)
{          
    Fr_interrupt_handler();  
}
#pragma CODE_SEG FLEXRAY_WAKEUP_ISR_CODE

/*******************************************************************************/
/* FlexRay Protocol Interrupt Service Routine                                  */
/*******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt FLEXRAY_Protocol_Isr(void)
{      
    Fr_interrupt_handler(); 
}
#pragma CODE_SEG FLEXRAY_PROTOCOL_ISR_CODE







            
