
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * HOSTCOMM.H                                                                  *
 * Host communication module                                                   *
 *                                                                             *
 * Originally created by: Jozef Polak                                          *
 * Modified by: Filip Brtan                                                    *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

#include "typedefs.h"


#pragma DATA_SEG HOSTCOMM_DATA
#pragma CODE_SEG HOSTCOMM_CODE

/*** Initialization ***/
void hostcomm_initialize (void);       // initialization of the host communication

/*** Host Communication ***/
void hostcomm_process_SCI0 (void);     // host communication frame processing: UART
void hostcomm_process_CAN (void);      // Host communication frame processing: CAN

/* computation of checksum for the frame */
byte hostcomm_framecheck(TBUFFER_DATA *buffer, byte length);  
/* Application-level processing of the frame. */
static void hostcomm_application (TBUFFER_DATA *prxdata, byte rxlength, TBUFFER_DATA *ptxdata, byte *txlength);
/* Send frame to another node. */
void hostcomm_CAN_command (TBUFFER_DATA *prxdata, byte rxlength, TBUFFER_DATA *ptxdata, byte *txlength);
    


#pragma CODE_SEG DEFAULT