
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * HOST.H                                                                      *
 * Host command processor                                                      *
 *                                                                             *
 * Originally created by: Jozef Polak                                          *
 * Modified by: Filip Brtan                                                    *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

// INSTRUCTIONS:
// 1. Load the RX data array with the received data for the command (header, i.e. the group and command bytes, are NOT part of the data).
// 2. Initialize the TX data pointer to allocated memory buffer for the response. Remember the address, because the pointer will change.
// 2. Call the appropriate function from the host_command[] array. 
//    Index in the array is the group byte, the command byte is the parameter for the function.
// 3. The TX data array will contain the data for the response. The TX data pointer points one byte after the last valid byte.

#pragma DATA_SEG HOST_DATA
#pragma CODE_SEG HOST_CODE

/* General Packet Definitions */
#define CMD_ACK        0x80    // the ACK field of the command byte
#define CMD_QUERY      0x80    // the query bit of the command byte

/* Command Processing Functions */
typedef void THOST_COMMANDGROUP (byte command);   // function that processes a command group

extern THOST_COMMANDGROUP *host_command [];       // table of functions that process command groups

/* Data for the Command Processing */
extern TBUFFER_DATA *host_prxdata;     // received command-specific data (see documentation) for the received command
extern TBUFFER_DATA *host_ptxdata;     // command-specific data (see documentation) for the response
extern byte          host_rxlength;    // length of received command-specific data


void SendCANCommand(byte Group, byte Command, word Data1, word Data2, word Data3, word Data4);
void SendCANCommand_bytes(byte Group, byte Command, byte Data1, byte Data2, byte Data3, byte Data4,
                                                    byte Data5, byte Data6, byte Data7, byte Data8);
void ext_trig(void);
/* Measure fr bd supplies */
byte ADC_measure_VIO(word *voltage);
byte ADC_measure_VCC(word *voltage);
/* Measure all flexray bus driver supplies */
byte ADC_measure_BD_supplies(word *vio, word *vcc);
/* Read parameters received with app test command */
void read_parameters(word *data1, word *data2, word *data3, word *data4);
/* Read parameters received with app test command */
void read_parameters_byte(byte *data1, byte *data2, byte *data3, byte *data4,
                          byte *data5, byte *data6, byte *data7, byte *data8);
                          
#pragma CODE_SEG DEFAULT
