
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * GPIO_macros.h                                                               *
 * General purpose IO macros                                                   *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/
 
#ifndef _GPIO_MACROS_H
#define _GPIO_MACROS_H

/* Variable types and common definitions */
#include "typedefs.h"   

/*******************************************************************************/
/* LEDs                                                                        */
/*******************************************************************************/
/* OUTPUT SIGNALS (0 => LED ON)*/                   
#define LEDS_ADDRESS PTP

#define LED1 PTP_PTP0
#define LED2 PTP_PTP1
#define LED3 PTP_PTP2
#define LED4 PTP_PTP3
#define LED5 PTP_PTP4
#define LED6 PTP_PTP5
#define LED7 PTP_PTP6
#define LED8 PTP_PTP7

#define LED1_MASK 0b00000001
#define LED2_MASK 0b00000010
#define LED3_MASK 0b00000100
#define LED4_MASK 0b00001000
#define LED5_MASK 0b00010000
#define LED6_MASK 0b00100000
#define LED7_MASK 0b01000000
#define LED8_MASK 0b10000000



/*******************************************************************************/
/* 8 way DIP Switch definition                                                 */
/*******************************************************************************/
/* INPUT SIGNALS */
#define SW_ADDRESS  PTIT
 
#define SW_ADDR0  PTIT_PTIT0
#define SW_ADDR1  PTIT_PTIT1 
#define SW_ADDR2  PTIT_PTIT2 
#define SW_ADDR3  PTIT_PTIT3 
#define SW_ADDR4  PTIT_PTIT4
#define SW_ADDR5  PTIT_PTIT5 
#define SW_ADDR6  PTIT_PTIT6 
#define SW_ADDR7  PTIT_PTIT7  

/* Auxiliary MCU IO's */ 
#define AUX_SS   PTS_PTS7
#define AUX_SCK  PTS_PTS6
#define AUX_MOSI PTS_PTS5
#define AUX_MISO PTS_PTS4
#define AUX_TXD  PTS_PTS3
#define AUX_RXD  PTS_PTS2

/* Aux Triger output */
#define TRIG1 AUX_SS
#define TRIG2 AUX_SCK
           
/*******************************************************************************/
/* Buttons definition                                                          */
/*******************************************************************************/
/* INPUT SIGNAL (0=> Button pressed)*/
#define BTN2 PORTE_PE1         /* Maskable External interrupt pin */


/*******************************************************************************/
/* Voltage regulator INH input control                                         */
/*******************************************************************************/
/* Inhibit functin of voltage regulators */
/* INH_VCC */
/* INH_VCC=0 - MCU is not supplied if BD is in SLEEP mode (J20 must be open) */
/* INH_VCC=1 - MCU is supplied if BD is in SLEEP mode */
#define INH_VCC_DISABLE PT01AD_PT1AD3
/* INH_VIO */
/* INH_VIO=0 - VIO is OFF only if BD is in SLEEP mode (J30 must be closed) */
/* INH_VIO=1 - VIO is still ON (even if BD is in SLEEP mode) */
#define INH_VIO_DISABLE PORTA_PA6


/*******************************************************************************/
/* CAN transceiver signals                                                     */
/*******************************************************************************/
/* STB signal - Enable CAN transmitter  */
#define CAN_STB PTM_PTM5

#define EnableCAN_BD() CAN_STB=0
#define DisableCAN_BD() CAN_STB=1


/*******************************************************************************/
/* FLEXRAY transceiver signals                                                 */
/*******************************************************************************/
/* Output */
#define FR_EN_A    PTH_PTH3   /* Channel A ENABLE pin */
#define FR_EN_B    PTH_PTH7   /* Channel B ENABLE pin */

#define FR_BGE_A   PORTA_PA3   /* Channel A BGE pin */
#define FR_BGE_B   PORTE_PE2   /* Channel B BGE pin */

#define FR_STBN_A  PORTA_PA2   /* Channel A STANDBY pin */
#define FR_STBN_B  PORTB_PB1   /* Channel B STANDBY pin */

#define FR_TXEN_A   PTH_PTH2   /* Channel A TXEN pin */
#define FR_TXEN_B   PTH_PTH6   /* Channel B TXEN pin */

#define FR_TXD_A   PTH_PTH1   /* Channel A TXD pin */
#define FR_TXD_B   PTH_PTH5   /* Channel B TXD pin */

/* Input */                              
#define FR_RXEN_A  PORTA_PA0 /* Channel A RXEN pin */
#define FR_RXEN_B  PORTB_PB0 /* Channel B RXEN pin */

#define FR_ERRN_A  PORTA_PA1  /* Channel A ERRN pin */
#define FR_ERRN_B  PORTE_PE3  /* Channel B ERRN pin */

#define FR_RXD_A   PTIH_PTIH0   /* Channel A RXD pin */
#define FR_RXD_B   PTIH_PTIH4   /* Channel B RXD pin */

/* Multi output macros */
#define FR_CLR_TXD_AB() {asm BCLR _PTH,#0b00100010;}  /* Set TXDA and TXENA to 0 */
#define FR_SET_TXD_AB() {asm BSET _PTH,#0b00100010;}  /* Set TXDA and TXENA to 0 */
#define FR_CLR_TXEN_AB() {asm BCLR _PTH,#0b01000100;}  /* Set TXDA and TXENA to 0 */
#define FR_SET_TXEN_AB() {asm BSET _PTH,#0b01000100;}  /* Set TXDA and TXENA to 0 */
#define FR_CLR_TXD_TXEN_A() {asm BCLR _PTH,#0b00000110;}  /* Set TXDA and TXENA to 0 */
#define FR_CLR_TXD_TXEN_B() {asm BCLR _PTH,#0b01100000;}  /* Set TXDB and TXENB to 0 */
#define FR_SET_TXD_TXEN_A() {asm BSET _PTH,#0b00000110;}  /* Set TXDA and TXENA to 1 */
#define FR_SET_TXD_TXEN_B() {asm BSET _PTH,#0b01100000;}  /* Set TXDB and TXENB to 1 */   
#define FR_CLR_TXD_TXEN_AB() {asm BCLR _PTH,#0b01100110;}  /* Set TXDAB and TXENAB to 0 */
#define FR_SET_TXD_TXEN_AB() {asm BSET _PTH,#0b01100110;}  /* Set TXDAB and TXENAB to 1 */





/*******************************************************************************/
/* Voltage measurement channel select definition                               */
/*******************************************************************************/
#define BD_INH2_B   0  // 0
#define BD_INH1_B   1  // 1
#define VCC_5V_BD   2  // 2
#define BD_INH2_A   3  // 8
#define BD_INH1_A   4  // 9
#define VCC_5V      5  // 10

/*******************************************************************************/
/* Macros                                                                      */
/*******************************************************************************/



/*******************************************************************************/
/* Indicator LEDs handling                                                     */
/*******************************************************************************/
 /* Set LED */ 
#define LED_ON(BitName)         (BitName = 0)
  
/* Clear LED */ 
#define LED_OFF(BitName)        (BitName = 1)

/* Toggle LED */ 
#define LED_TOGGLE(BitName)     (BitName ^= 1) 

/*******************************************************************************/
/* PTI Timer macros                                                            */
/*******************************************************************************/
#define TIMER_100ns_START     PITFLT_PITFLT0 = 1
#define TIMER_1ms_START       PITFLT_PITFLT1 = 1 
#define TIMER_100ns_ELAPSED   PITTF_PITTF0
#define TIMER_1ms_ELAPSED     PITTF_PITTF1


#endif /* _GPIO_MACROS_H */

/*******************************************************************************/