/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * FlexRay_CC.h                                                                *
 * FlexRay module handling function prototypes                                 *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

/* Standard and driver types */
#include "Fr_UNIFIED_types.h" 
#include "Fr_UNIFIED.h"   


#pragma DATA_SEG FlexRay_CC_DATA
#pragma CODE_SEG FlexRay_CC_CODE

/*******************************************************************************/
/* Global variables                                                            */
/*******************************************************************************/

/*  */
extern byte payload_length;
/*  */
extern word tx_data[5][16];
/*  */
extern byte LEDS;
/*  */
extern bool FlexRay_CC_initialized;


/* Function Prototypes */

/* Error function for debugging */
void Failed(byte u8number);

/* Function for transmission */
void CC_interrupt_1(byte buffer_idx);
void CC_interrupt_2(byte buffer_idx);
void CC_interrupt_3(byte buffer_idx);
void CC_interrupt_4(byte buffer_idx);
void CC_interrupt_5(byte buffer_idx);
/* Functions for reception */
void CC_interrupt_rx_1(byte buffer_idx);
void CC_interrupt_rx_2(byte buffer_idx);
void CC_interrupt_rx_3(byte buffer_idx);
void CC_interrupt_rx_4(byte buffer_idx);
void CC_interrupt_rx_5(byte buffer_idx);

/* Function for FlexRay Timer 1 */
void CC_interrupt_timer_1(void);

/* Function for FlexRay Timer 2 */
void CC_interrupt_timer_2(void);

/* Function for FlexRay wakeup interrupt */
void CC_interrupt_wakeup(void);

/* Function for FlexRay protocol interrupt */
void CC_interrupt_protocol(void);

/* Function for FlexRay cycle start interrupt */
void CC_interrupt_cycle_start(void);

/* Function for FlexRay protocol state changed interrupt */
void CC_interrupt_protocol_state_changed(void);

/* FlexRay Message buffers first initialization */
Fr_return_type Fr_init_message_buffers(void);

/*  */
void FlexRay_CC_configuration(void);

/** FlexRay module configuration */
void FlexRay_Init(void);

/* CRC Calculation */
#define vCrcInit ((word) 0x1A)
#define vCrcPolynomial ((word) 0x385)
word Calculate_Header_Crc(bool SyncFrame, bool StartupFrame, word FrameId, byte PayloadLength);

#pragma DATA_SEG DEFAULT

/*******************************************************************************/