/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * FlexRay_BD.h                                                                *
 * FlexRay module handling function prototypes                                 *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

/** UNIFIED driver implementation */         
#include "Fr_UNIFIED.h"           


/*! \enum Fr_BD_mode_type
 * Type definition of the FlexRay bus driver modes.
 */
typedef enum
{
    FR_BD_NORMAL = 0,         // Normal mode
    FR_BD_RECEIVE_ONLY,       // Receive-only mode
    FR_BD_STANDBY,            // Standby mode
    FR_BD_GOTOSLEEP,          // Go-to-sleep mode
    FR_BD_SLEEP               // Sleep mode
} Fr_BD_mode_type;


/* Flags definitions */

#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/*******************************************************************************/
/** Fr_bd_flags
 * \union Fr_bd_flags FlexRay_BD.h
 * description Fr_bd_flags
 */
typedef union {
  word Word;
  struct { 
    word LocalWakeUp      :1;    /*!< Local Wakeup detected */
    word RemoteWakeUp     :1;    /*!< Remote Wakeup detected */
    word S2               :1;    /*!< Not used */
    word PowerOn          :1;    /*!< Power on flag */
    word BusError         :1;    /*!< Bus Error detected */
    word ThermalShutdown  :1;
    word ThermalWarning   :1;
    word TxenBgeTimeout   :1;
    word VbatUV           :1;
    word VccUV            :1;
    word VioUV            :1; 
    word S11              :1;
    word S12              :1;
    word S13              :1;
    word S14              :1;
    word S15              :1;
  } Bits;
} Fr_bd_flags;

/*******************************************************************************/
/** Fr_bd_version
 * \union Fr_bd_version FlexRay_BD.h
 * description Fr_bd_version
 */
typedef union {
  word Word;
  struct { 
    word S16              :1;  /*!< S16*/
    word S17              :1;
    word S18              :1;
    word S19              :1;
    word S20              :1;
    word S21              :1;
    word S22              :1;
    word S23              :1;
    word S24              :1;
    word S25              :1;
    word S26              :1;
    word S27              :1;
    word S28              :1;
    word S29              :1;
    word S30              :1;
    word S31              :1;
  } Bits;
  struct {
    word Analog           :8;
    word Digital          :8;
  } MergedBits; 
} Fr_bd_version;


/*******************************************************************************/
/** Fr_bd_status_register
 * \struct Fr_bd_status_register FlexRay_BD.h
 */
typedef struct{
  Fr_bd_flags Flags;      /**< Flags */
  Fr_bd_version Version;  /**< Version */
} Fr_bd_status_register;




void wait_100ns(UINT16 count100ns);
void wait_1us(UINT16 count1us);
void wait_1ms(void);

/* Status Register readout */
Fr_bd_status_register fr_bd_read_status(Fr_channel_type channel);
Fr_bd_status_register fr_bd_read_status_A(void);
Fr_bd_status_register fr_bd_read_status_B(void);
void fr_bd_read_status_AB(Fr_bd_status_register *status1, Fr_bd_status_register *status2);

/* Status Register readout with different number of clocks */
void fr_bd_read_status_special(byte no_of_bits, word delay);

/*  */
void fr_bd_change_mode(Fr_channel_type channel, Fr_BD_mode_type mode);

/* Test Patterns */

/* Valid Remote Wakeup Test Patterns */
void TestPatternRemoteWakeup(Fr_channel_type channel);
/* Alternative Remote Wakeup Test Patterns */
void TestPatternRemoteWakeupAlternative(Fr_channel_type channel);
/* Shorted Remote Wakeup Test Patterns */
void TestPatternRemoteWakeupShorted(Fr_channel_type channel);
/* Remote Wakeup Frame Payload Test Patterns */
void TestPatternRemoteWakeupFrame(Fr_channel_type channel);
/* Non Valid Remote Wakeup Test Patterns - short IDLE*/
void TestPatternRemoteWakeupFailShortIdle(Fr_channel_type channel);
/* Non Valid Remote Wakeup Test Patterns - long IDLE*/
void TestPatternRemoteWakeupFailLongIdle(Fr_channel_type channel);
/* Non Valid Remote Wakeup Test Patterns - short firs LOW */
void TestPatternRemoteWakeupFailShortLow1(Fr_channel_type channel);
/* Non Valid Remote Wakeup Test Patterns - short second LOW */
void TestPatternRemoteWakeupFailShortLow2(Fr_channel_type channel);

/* TSS Test Patterns */
void TestPatternTSS(Fr_channel_type channel);
/* TSS + one 10gdBit LOW Test Patterns */
void TestPatternTSS_LOW(Fr_channel_type channel);
/* TSS + one 10gdBit HIGH Test Patterns */
void TestPatternTSS_HIGH(Fr_channel_type channel);
/* TSS + one 10gdBit High + one 10gdBit LOW Test Pattern */
void TestPatternTSS_HIGH_LOW(Fr_channel_type channel);
/* TSS + one 50/50 Test Pattern */
void TestPatternTSS_50_50(Fr_channel_type channel);
/* TSS + one 10/90 Test Pattern */
void TestPatternTSS_10_90(Fr_channel_type channel);
/* Two 50/50 Test Patterns */
void TestPattern_Two_50_50(Fr_channel_type channel);
/* Current Measurement Test Patterns - long IDLE */
void TestPatternCurrentMeasurement(Fr_channel_type channel);

/* Configuration of CPU pins connected to FR bus driver */
void Fr_bd_ports_init(void);

#ifndef __V30COMPATIBLE__
//#pragma OPTION DEL V30toV31Compatible
#endif
/*******************************************************************************/