/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation KIT                                                      *
 *                                                                             *
 * Fr_UNIFIED_CFG.h                                                            *
 * FlexRay High-Level Driver implementation                                    *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2011                                                            *
 *                                                                             *
 *                                                                             *
 * Based on file Fr_UNIFIED_cfg.h.backup                                       *
 *               author    R62779 (Freescale Semiconductor Inc.)               *
 *               version   1.0.9.0                                             *
 *               date      Nov-23-2006                                         *
 *                                                                             *
 *******************************************************************************/

#ifndef _FR_UNIFIED_CFG_H
#define _FR_UNIFIED_CFG_H

/******************************************************************************
* Constants
******************************************************************************/

// The host can optimize the driver memory consumption by passing the number of the highest 
// used transmit or receive message buffer index (not shadow and FIFO) - configured 
// in the instance of the Fr_buffer_info_type structure
// Note - it is not necessary to define the FR_NUMBER_TXRX_MB parameter for correct driver operation
#define FR_NUMBER_TXRX_MB 10     // The driver will allocate only limited number of elements in an internal array


/*******************************************************************************/
/* Global variables                                                            */
/*******************************************************************************/

extern Fr_HW_config_type Fr_HW_cfg_01;
extern Fr_transmit_buffer_config_type Fr_tx_buffer_cfg[5];
extern Fr_receive_buffer_config_type  Fr_rx_buffer_cfg[5];
extern Fr_buffer_info_type Fr_buffer_cfg_01[10];
extern Fr_index_selector_type Fr_buffer_cfg_set_01[11];
extern Fr_timer_config_type Fr_timer_1_cfg;
extern Fr_timer_config_type Fr_timer_2_cfg;
extern const Fr_timer_config_type * Fr_timers_cfg_00_ptr[];
extern Fr_low_level_config_type Fr_low_level_cfg_set_01;

#endif /* _FR_UNIFIED_CFG_H */