/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation KIT                                                      *
 *                                                                             *
 * Fr_UNIFIED_CFG.c                                                            *
 * FlexRay High-Level Driver implementation                                    *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2011                                                            *
 *                                                                             *
 *                                                                             *
 * Based on file Fr_UNIFIED_cfg.c.backup                                       *
 *               author    R62779 (Freescale Semiconductor Inc.)               *
 *               version   1.0.7.0                                             *
 *               date      Mar-14-2007                                         *
 *                                                                             *
 *******************************************************************************/

#include "Fr_UNIFIED.h"

/*******************************************************************************/
/* Global variables                                                            */
/*******************************************************************************/

// Hardware configuration structure
// Number of MB in Segment 1:   15
// Number of MB in Segment 2:   0
// FIFO Depth:                  0
Fr_HW_config_type Fr_HW_cfg_01 =
{
    0x000400,       // FlexRay module base address
    0x0FF000,       // FlexRay memory base address (MB headers start at this address)
    FR_MC9S12XF,    // Type of Freescale FlexRay module
    FALSE,          // Synchronization filtering
    FR_INTERNAL_SYSTEM_BUS_CLOCK,
    0,              // Value of the PRESCALE or BITRATE bit field in the MCR register
    6,              // Data size - segment 1
    8,              // Data size - segment 2
    14,             // Last MB in segment 1 (Number of MB in Segment1 - 1)
    14,             // Last individual MB (except FIFO); (Number of MB in Segment1 + Number of MB in Segment2 - 1)
    15,             // Total number of used MB (Last_individual_MB + 1 + FIFO)
    TRUE,           // Allow coldstart
    0,              // The value of the TIMEOUT bit field in the SYMATOR register - not implemented for all FlexRay modules
    0,              // Offset of the Sync Frame Table in the FlexRay memory
    FR_DUAL_CHANNEL_MODE    // Single channel mode disabled
};

// Transmit MB configuration structure 1
Fr_transmit_buffer_config_type Fr_tx_buffer_cfg[5] = {
  {
     1,                           // Transmit frame ID
     807,                         // Header CRC
     6,                           // Payload length
     FR_SINGLE_TRANSMIT_BUFFER,   // Transmit MB buffering
     FR_STATE_TRANSMISSION_MODE,  // Transmission mode
     FR_STREAMING_COMMIT_MODE,    // Transmission commit mode
     FR_CHANNEL_AB,               // Transmit channels
     FALSE,                       // Payload preamble
     FALSE,                       // Transmit cycle counter filter enable
     0,                           // Transmit cycle counter filter value
     0,                           // Transmit cycle counter filter mask
     TRUE,                        // Transmit MB interrupt enable
     FALSE                        // Used only for double buffer
  },
  {
     2,                           // Transmit frame ID
     1563,                        // Header CRC
     6,                           // Payload length
     FR_SINGLE_TRANSMIT_BUFFER,   // Transmit MB buffering
     FR_STATE_TRANSMISSION_MODE,  // Transmission mode
     FR_STREAMING_COMMIT_MODE,    // Transmission commit mode
     FR_CHANNEL_AB,               // Transmit channels
     FALSE,                       // Payload preamble
     FALSE,                       // Transmit cycle counter filter enable
     0,                           // Transmit cycle counter filter value
     0,                           // Transmit cycle counter filter mask
     TRUE,                        // Transmit MB interrupt enable
     FALSE                        // Used only for double buffer
  },
  {
     3,                           // Transmit frame ID
     2030,                        // Header CRC
     6,                           // Payload length
     FR_SINGLE_TRANSMIT_BUFFER,   // Transmit MB buffering
     FR_STATE_TRANSMISSION_MODE,  // Transmission mode
     FR_STREAMING_COMMIT_MODE,    // Transmission commit mode
     FR_CHANNEL_AB,               // Transmit channels
     FALSE,                       // Payload preamble
     FALSE,                       // Transmit cycle counter filter enable
     0,                           // Transmit cycle counter filter value
     0,                           // Transmit cycle counter filter mask
     TRUE,                        // Transmit MB interrupt enable
     FALSE                        // Used only for double buffer
  },
  {
     4,                           // Transmit frame ID
     549,                         // Header CRC
     6,                           // Payload length
     FR_SINGLE_TRANSMIT_BUFFER,   // Transmit MB buffering
     FR_STATE_TRANSMISSION_MODE,  // Transmission mode
     FR_STREAMING_COMMIT_MODE,    // Transmission commit mode
     FR_CHANNEL_AB,               // Transmit channels
     FALSE,                       // Payload preamble
     FALSE,                       // Transmit cycle counter filter enable
     0,                           // Transmit cycle counter filter value
     0,                           // Transmit cycle counter filter mask
     TRUE,                        // Transmit MB interrupt enable
     FALSE                        // Used only for double buffer
  },
  {
     5,                           // Transmit frame ID
     976,                         // Header CRC
     6,                           // Payload length
     FR_SINGLE_TRANSMIT_BUFFER,   // Transmit MB buffering
     FR_STATE_TRANSMISSION_MODE,  // Transmission mode
     FR_STREAMING_COMMIT_MODE,    // Transmission commit mode
     FR_CHANNEL_AB,               // Transmit channels
     FALSE,                       // Payload preamble
     FALSE,                       // Transmit cycle counter filter enable
     0,                           // Transmit cycle counter filter value
     0,                           // Transmit cycle counter filter mask
     TRUE,                        // Transmit MB interrupt enable
     FALSE                        // Used only for double buffer
  }
};

// Receive MB configuration structure
Fr_receive_buffer_config_type  Fr_rx_buffer_cfg[5] = {  
  {
     1,                           // Receive frame ID
     FR_CHANNEL_B,                // Receive channel enable
     FALSE,                       // Receive cycle counter filter enable
     0x0000,                      // Receive cycle counter filter value
     0x0000,                      // Receive cycle counter filter mask
     TRUE                         // Receive MB interrupt enable
  },
  {
     2,                           // Receive frame ID
     FR_CHANNEL_B,                // Receive channel enable
     FALSE,                       // Receive cycle counter filter enable
     0x0000,                      // Receive cycle counter filter value
     0x0000,                      // Receive cycle counter filter mask
     TRUE                         // Receive MB interrupt enable
  },
  {
     3,                           // Receive frame ID
     FR_CHANNEL_B,                // Receive channel enable
     FALSE,                       // Receive cycle counter filter enable
     0x0000,                      // Receive cycle counter filter value
     0x0000,                      // Receive cycle counter filter mask
     FALSE                        // Receive MB interrupt enable
  },
  {
     4,                           // Receive frame ID
     FR_CHANNEL_B,                // Receive channel enable
     FALSE,                       // Receive cycle counter filter enable
     0x0000,                      // Receive cycle counter filter value
     0x0000,                      // Receive cycle counter filter mask
     FALSE                        // Receive MB interrupt enable
  },
  {
     5,                           // Receive frame ID
     FR_CHANNEL_B,                // Receive channel enable
     FALSE,                       // Receive cycle counter filter enable
     0x0000,                      // Receive cycle counter filter value
     0x0000,                      // Receive cycle counter filter mask
     FALSE                        // Receive MB interrupt enable
  }
};


// Following array is used to determine which message buffers defined in Fr_buffer_cfg_xx structure
// will be used for the FlexRay CC configuration
Fr_index_selector_type Fr_buffer_cfg_set_01[11] =
{
    0, 5, 6, 7, 8, 9, FR_LAST_MB
};

// Array of structures with message buffer configuration information
Fr_buffer_info_type Fr_buffer_cfg_01[10] =
{ /* Buffer type         Configuration structure ptr    MB index       xx = configuration index used by Fr_buffer_cfg_set_xx */
    {FR_TRANSMIT_BUFFER, &Fr_tx_buffer_cfg[0],          0},         // 00
    {FR_TRANSMIT_BUFFER, &Fr_tx_buffer_cfg[1],          1},         // 01
    {FR_TRANSMIT_BUFFER, &Fr_tx_buffer_cfg[2],          2},         // 02
    {FR_TRANSMIT_BUFFER, &Fr_tx_buffer_cfg[3],          3},         // 03
    {FR_TRANSMIT_BUFFER, &Fr_tx_buffer_cfg[4],          4},         // 04
    {FR_RECEIVE_BUFFER,  &Fr_rx_buffer_cfg[0],          5},         // 05
    {FR_RECEIVE_BUFFER,  &Fr_rx_buffer_cfg[1],          6},         // 06
    {FR_RECEIVE_BUFFER,  &Fr_rx_buffer_cfg[2],          7},         // 07
    {FR_RECEIVE_BUFFER,  &Fr_rx_buffer_cfg[3],          8},         // 08
    {FR_RECEIVE_BUFFER,  &Fr_rx_buffer_cfg[4],          9}          // 09

};

// Configuration data for absolute timer T1
Fr_timer_config_type Fr_timer_1_cfg = 
{
    FR_TIMER_T1, 			// Timer number (T1 or T2)
    FR_ABSOLUTE, 			// Timer timebase
    FR_REPETITIVE, 		// Timer repetition mode
    2050, 						// Timer macrotick offset
    0, 								// Timer cycle filter mask, only for absolute timer
    0									// Timer cycle filter value, only for absolute timer
};

// Configuration data for relative timer T2
Fr_timer_config_type Fr_timer_2_cfg = 
{
    FR_TIMER_T2, 			// Timer number (T1 or T2)
    FR_RELATIVE, 			// Timer timebase
    FR_REPETITIVE, 		// Timer repetition mode
    1000000, 					// Timer macrotick offset
    0, 								// Timer cycle filter mask, only for absolute timer
    0									// Timer cycle filter value, only for absolute timer
};

// Array with timers configuration information
// Following array is used to determine which timers will be used for the FlexRay CC configuration
const Fr_timer_config_type * Fr_timers_cfg_00_ptr[] =
{   
    &Fr_timer_1_cfg,   // Pointer to configuration structure for timer T1
    &Fr_timer_2_cfg,   // Pointer to configuration structure for timer T2
    NULL
};
	
// Structure of this type contains configuration
// information of the one low level parameters set
Fr_low_level_config_type Fr_low_level_cfg_set_01 =
{
    10,           // G_COLD_START_ATTEMPTS  
    4,            // GD_ACTION_POINT_OFFSET  
    76,           // GD_CAS_RX_LOW_MAX  
    0,            // GD_DYNAMIC_SLOT_IDLE_PHASE  
    40,           // GD_MINISLOT  
    3,            // GD_MINI_SLOT_ACTION_POINT_OFFSET  
    31,           // GD_STATIC_SLOT  
    14,           // GD_SYMBOL_WINDOW  
    7,            // GD_TSS_TRANSMITTER  
    59,           // GD_WAKEUP_SYMBOL_RX_IDLE  
    50,           // GD_WAKEUP_SYMBOL_RX_LOW  
    301,          // GD_WAKEUP_SYMBOL_RX_WINDOW  
    180,          // GD_WAKEUP_SYMBOL_TX_IDLE  
    60,           // GD_WAKEUP_SYMBOL_TX_LOW  
    2,            // G_LISTEN_NOISE  
    10000,        // G_MACRO_PER_CYCLE  
    10,           // G_MAX_WITHOUT_CLOCK_CORRECTION_PASSIVE  
    14,           // G_MAX_WITHOUT_CLOCK_CORRECTION_FATAL  
    0,            // G_NUMBER_OF_MINISLOTS  
    10,           // G_NUMBER_OF_STATIC_SLOTS  
    9991,         // G_OFFSET_CORRECTION_START  
    6,            // G_PAYLOAD_LENGTH_STATIC  
    5,            // G_SYNC_NODE_MAX  
    2,            // G_NETWORK_MANAGEMENT_VECTOR_LENGTH  
    FALSE,        // G_ALLOW_HALT_DUE_TO_CLOCK  
    20,           // G_ALLOW_PASSIVE_TO_ACTIVE  
    FR_CHANNEL_AB,// P_CHANNELS  
    133,          // PD_ACCEPTED_STARTUP_RANGE  
    1,            // P_CLUSTER_DRIFT_DAMPING  
    40,           // P_DECODING_CORRECTION  
    1,            // P_DELAY_COMPENSATION_A  
    1,            // P_DELAY_COMPENSATION_B  
    802404,       // PD_LISTEN_TIMEOUT  
    1202,         // PD_MAX_DRIFT  
    0,            // P_EXTERN_OFFSET_CORRECTION  
    0,            // P_EXTERN_RATE_CORRECTION  
    1,            // P_KEY_SLOT_ID  
    TRUE,         // P_KEY_SLOT_USED_FOR_STARTUP  
    TRUE,         // P_KEY_SLOT_USED_FOR_SYNC  
    807,          // P_KEY_SLOT_HEADER_CRC  
    0,            // P_LATEST_TX  
    6,            // P_MACRO_INITIAL_OFFSET_A  
    6,            // P_MACRO_INITIAL_OFFSET_B  
    0,            // P_MICRO_INITIAL_OFFSET_A  
    0,            // P_MICRO_INITIAL_OFFSET_B  
    400000,       // P_MICRO_PER_CYCLE  
    167,          // P_OFFSET_CORRECTION_OUT  
    1202,         // P_RATE_CORRECTION_OUT  
    FALSE,        // P_SINGLE_SLOT_ENABLED  
    FR_CHANNEL_B, // P_WAKEUP_CHANNEL  
    2,            // P_WAKEUP_PATTERN 
    40,           // P_MICRO_PER_MACRO_NOM 
    8             // P_PAYLOAD_LENGTH_DYN_MAX
};

