 
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * Cpu.h                                                                       *
 * S12XF512 CPU initialization                                                 *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/
 
#ifndef _CPU_H
#define _CPU_H

#pragma DATA_SEG DEFAULT

/* Global variables */
extern volatile byte CCR_reg;          /* Current CCR reegister */

#pragma CODE_SEG DEFAULT

/* Function Prototypes */

/* System clock and PLL initialization */
void Clock_Settings(void);

/* FlexRay IPLL initialization */
void IPLL_Startup(void);

/* CPU, memory and ports settings */
void Peripheral_Settings(void);

/* Programmable Interrupt Timer (PIT) module registers configuration*/
void PIT_Init(void);

/* Software MCU reset (watchdog counter overflow)  */
void MCU_Software_Reset(void);

/* Interrupts configuration */
void Interrupts_Init(void);

#endif /* _CPU_H */

/*******************************************************************************/