
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * HOSTCOMM.H                                                                  *
 * Host communication module                                                   *
 *                                                                             *
 * Originally created by: Jozef Polak                                          *
 * Modified by: Filip Brtan                                                    *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

#include "typedefs.h"


#pragma DATA_SEG CAN_HOSTCOMM_DATA
#pragma CODE_SEG CAN_HOSTCOMM_CODE

/*** Initialization ***/
void CAN_hostcomm_initialize (void);       // initialization of the host communication

/*** Host Communication ***/

/* Send Command - Master Node  */
void CAN_send_command(byte group, byte command, byte *data, byte data_length);

/* host communication frame processing: CAN */
void CAN_hostcomm_process (void);     

/* Master Host communication frame processing: CAN */
byte CAN_master_hostcomm_process (byte *group, byte *command, byte *data, byte *data_length);

#pragma CODE_SEG DEFAULT