
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * CAN_HOST.H                                                                  *
 * Host command processor                                                      *
 *                                                                             *
 * Originally created by: Jozef Polak                                          *
 * Modified by: Filip Brtan                                                    *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/

// INSTRUCTIONS:
// 1. Load the RX data array with the received data for the command (header, i.e. the group and command bytes, are NOT part of the data).
// 2. Initialize the TX data pointer to allocated memory buffer for the response. Remember the address, because the pointer will change.
// 2. Call the appropriate function from the host_command[] array. 
//    Index in the array is the group byte, the command byte is the parameter for the function.
// 3. The TX data array will contain the data for the response. The TX data pointer points one byte after the last valid byte.

#pragma DATA_SEG CAN_HOST_DATA
#pragma CODE_SEG CAN_HOST_CODE

/* General Packet Definitions */
#define CAN_CMD_ACK        0x80    // the ACK field of the command byte
#define CAN_CMD_QUERY      0x80    // the query bit of the command byte

/* Command Processing Functions */
typedef void CAN_THOST_COMMANDGROUP (byte command);   // function that processes a command group

extern CAN_THOST_COMMANDGROUP *CAN_host_command [];       // table of functions that process command groups

/* Data for the Command Processing */
extern TBUFFER_DATA *CAN_host_prxdata;     // received command-specific data (see documentation) for the received command
extern TBUFFER_DATA *CAN_host_ptxdata;     // command-specific data (see documentation) for the response
extern byte          CAN_host_rxlength;    // length of received command-specific data


#pragma CODE_SEG DEFAULT
