
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * CAN.h                                                                       *
 * CAN interface                                                               *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/


/* Variable types */
#include "typedefs.h"


#pragma DATA_SEG CAN_DATA
#pragma CODE_SEG CAN_CODE

#ifndef _CAN_H
#define _CAN_H


/* ERROR types definition */
#ifndef ERR_OK
#define ERR_OK           0             /* OK */
#endif

#ifndef ERR_RANGE
#define ERR_RANGE        1             /* Parameter out of range. */
#endif

#ifndef ERR_BUFFER_FULL
#define ERR_BUFFER_FULL  2 
#endif

/* Buffers */
#define SIZE_CAN_RXBUF   SIZE_COMM_BUFFERS  // Input buffer size
#define SIZE_CAN_TXBUF   SIZE_COMM_BUFFERS  // Output buffer size

/* CAN ID definition: Standard Id 0x002 formatted to be loaded in IDRx */ 
extern word CAN_node_ID; 

extern byte CAN_rxlen;              /* Length of output bufer's content */
extern byte CAN_txlen;              /* Length of input buffer's content */

/*** Buffers ***/
extern TBUFFER_DATA CAN_rxdata[SIZE_CAN_RXBUF];   /* reception data buffer  */
extern TBUFFER_DATA CAN_txdata[SIZE_CAN_TXBUF];   /* transmission data buffer */

/*** Data Reception ***/
byte CAN_received (void);          /* data reception finished */
void CAN_rxprocessed (void);       /* received data processed, get ready for next frame */

/*** Data Transmission ***/
void CAN_transmit (void);          /* request to transmit data in the TX buffer */
byte CAN_txactive (void);          /* transmission in progress */

/*  Tests the internal input break flag */
byte CAN_get_break(byte *Break);

/* Sends the break sequence to the output line. */
byte CAN_set_break(void);

/* Reset CAN buffer registers. Resyncronize frame reception*/
void CAN_on_error(void);

/* CAN frame transmission */
byte CAN_send_frame(byte Length, byte *TxData);

/* Read CAN reception buffer */
byte CAN_received_frame(word *pID, byte *pLength, byte *pRxData);

/* CAN initialization, baud rate = 500kbps, 16 bit acceptance filters */
void CAN_init(word node_ID);

#pragma CODE_SEG CAN_CODE

/*** Interrupts ***/
#pragma CODE_SEG __NEAR_SEG NON_BANKED

/* CAN transmission interrupt service routine */
void interrupt CAN0_TX_Isr(void);

/* CAN reception interrupt service routine */
void interrupt CAN0_RX_Isr(void);

/* CAN error interrupt service routine */
void interrupt CAN0_ERR_Isr(void);

#pragma CODE_SEG DEFAULT



#endif /* _CAN_H */




/*******************************************************************************/