
/*******************************************************************************
 * ON Semiconductor                                                            *
 * NCV7381B Evaluation Board V1                                                *
 *                                                                             *
 * ADC.h                                                                       *
 * Voltage measurement routines                                                *
 *                                                                             *
 * Created by: Filip Brtan                                                     *
 * Date: 20.06.2019                                                            *
 *******************************************************************************/
 
/* Include shared modules, which are used for whole project */
#include "mc9s12xf512.h" 
#include "Cpu.h"

#pragma DATA_SEG ADC_DATA
#pragma CODE_SEG ADC_CODE

/* ADC Interrupt Service Routine */
#pragma CODE_SEG __NEAR_SEG NON_BANKED
void interrupt ADC_Conv_Compl_Isr(void); 
#pragma CODE_SEG ADC_CODE
 
/* Perform one ADC measurement */
byte ADC_Measure(bool WaitForResult);
 
/* Get ADC measurement results from all active channels */
byte ADC_GetValue16(word *Values);
 
/* Get ADC measurement result from one specific channel */
byte ADC_GetChanValue16(byte Channel, word *Value);
 
/* ADC module initialization */
void ADC_init(void);
 
 
#pragma CODE_SEG DEFAULT

/*******************************************************************************/